/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.classification;

import data.structures.tagging.GraphLemmaItem;
import data.structures.tagging.LemmaItem;

import java.util.Vector;

public class Corpus {
    public Vector<NuagePondere> articles = new Vector<NuagePondere>();

    public Corpus(){

    }

    public void addArticle(NuagePondere article){
        articles.add(article);
    }

    public void addArticle(GraphLemmaItem article){
        NuagePondere nuage = new NuagePondere(article.getNodeID(), article.getNodeName());
        Vector<LemmaItem> v = new Vector<LemmaItem>(article.getLemmas());
        for(int i=0; i<v.size(); i++){
            LemmaItem l = v.elementAt(i);
            if(l.getCountTitle()>0){
                Vector<Operation> orig = new Vector<Operation>();
                orig.addElement(Operation.ACCES_TITRE);
                nuage.addLemme(new LemmePondere(l.getLemmaName(), orig,
                        l.getLemmaLex(), l.getCountTitle()));
            }
            if(l.getCountDesc()>0){
                Vector<Operation> orig = new Vector<Operation>();
                orig.addElement(Operation.ACCES_DESC);
                nuage.addLemme(new LemmePondere(l.getLemmaName(), orig,
                        l.getLemmaLex(), l.getCountDesc()));
            }
        }
        articles.add(nuage);
    }

    public NuagePondere[] getArticles(){
        NuagePondere[] result = new NuagePondere[articles.size()];
        articles.toArray(result);
        return result;
    }

    public void pondereOrigine(Operation origine, double poids){
        for(int i=0; i<articles.size(); i++){
            articles.elementAt(i).pondereOrigine(origine, poids);
        }
    }

    public void pondereCategorie(String categorie, double poids){
        for(int i=0; i<articles.size(); i++){
            articles.elementAt(i).pondereCategorie(categorie, poids);
        }
    }

    public void pondereAllCategories(double poids){
        for(int i=0; i<articles.size(); i++){
            articles.elementAt(i).pondereAllCategories(poids);
        }
    }
}
